<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Dragonbyte Technologies Advanced Post Thanks & Like Pro 1.1.9    # ||
|| # ---------------------------------------------------------------- # ||
|| # Nulled by x iJB x                                                # ||
|| # This is a p0wersurge.com release                                 # ||
|| # ---------------------------- Greetz ---------------------------- # ||
|| # TeamPS extends their greetz to all the nullification scene,      # ||
|| # including FS and DGT. Thanks go to FS for teaching me to null    # ||
|| # properly. Thanks also go to decodeby.us (RIP) for the ionCube    # ||
|| # decoder I use for decoding certain scripts :p                    # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// thanks functionality class

/**
* Handles everything to do with APTL.
*
* @package	APTL
* @version	$ $Rev$ $
* @date		$ $Date$ $
*/
class THANKS
{
	/**
	* Version info
	*
	* @public	mixed
	*/	
	public static $version 			= '1.1.9';
	public static $versionnumber	= 119;
	
	/**
	* The vBulletin registry object
	*
	* @private	vB_Registry
	*/	
	protected static $vbulletin 	= NULL;
	
	/**
	* The vBulletin registry object
	*
	* @private	vB_Registry
	*/	
	protected static $prefix 		= 'dbtech_';
	
	/**
	* The vBulletin registry object
	*
	* @private	vB_Registry
	*/	
	protected static $bitfieldgroup	= 'thankspermissions';
	
	/**
	* Array of permissions to be returned
	*
	* @public	array
	*/	
	public static $permissions 		= NULL;
	
	/**
	* Array of cached items
	*
	* @public	array
	*/		
	public static $cache			= array();
	
	/**
	* Whether we've called the DM fetcher
	*
	* @public	boolean
	*/		
	protected static $called		= false;
	
	/**
	* Array of created things
	*
	* @public	array
	*/		
	public static $created		= array();
	
	/**
	* Array of cached items
	*
	* @public	array
	*/		
	public static $unserialize		= array(
		'button' => array(
			'permissions'
		),
	);
	
	/**
	* Whether we have the pro version or not
	*
	* @public	boolean
	*/		
	public static $isPro		= false;
	
	/**
	* Array of cached entries
	*
	* @public	array
	*/		
	public static $entrycache	= array();

	
	/**
	* Does important checking before anything else should be going on
	*
	* @param	vB_Registry	Registry object
	*/
	public static function init($vbulletin)
	{
		// Check if the vBulletin Registry is an object
		if (!is_object($vbulletin))
		{
			// Something went wrong here I think
			trigger_error("Registry object is not an object", E_USER_ERROR);
		}
		
		// Set registry
		self::$vbulletin =& $vbulletin;
		
		// Set permissions shorthand
		self::get_permissions();
		
		// What permissions to override
		$override = array();
		
		foreach ($override as $permname)
		{
			// Override various permissions
			self::$permissions["$permname"] = (self::$permissions['ismanager'] ? 1 : self::$permissions["$permname"]);
		}
		
		foreach (self::$unserialize as $cachetype => $keys)
		{
			foreach ((array)self::$cache["$cachetype"] as $id => $arr)
			{
				foreach ($keys as $key)
				{
					// Do unserialize
					self::$cache["$cachetype"]["$id"]["$key"] = @unserialize($arr["$key"]);
				}
			}
		}
		
		// Set pro version
		self::$isPro = file_exists(DIR . '/includes/xml/bitfield_dbtech_thanks_pro.xml');
	}
	
	/**
	* Grabs what permissions we have got
	*/
	private static function get_permissions()
	{
		// Override bitfieldgroup variable
		$bitfieldgroup = self::$prefix . self::$bitfieldgroup;
		
		if (!is_array(self::$vbulletin->bf_ugp["$bitfieldgroup"]))
		{
			// Something went wrong here I think
			require_once(DIR . '/includes/class_bitfield_builder.php');
			if (vB_Bitfield_Builder::build(false) !== false)
			{
				$myobj =& vB_Bitfield_Builder::init();
				if (sizeof($myobj->data['ugp']["$bitfieldgroup"]) != sizeof(self::$vbulletin->bf_ugp["$bitfieldgroup"]))
				{
					require_once(DIR . '/includes/adminfunctions.php');					
					$myobj->save(self::$vbulletin->db);
					build_forum_permissions();
					
					if (IN_CONTROL_PANEL === true)
					{
						define('CP_REDIRECT', self::$vbulletin->scriptpath);
						print_stop_message('rebuilt_bitfields_successfully');
					}
					else
					{
						self::$vbulletin->url = self::$vbulletin->scriptpath;
						eval(print_standard_redirect('redirect_updatethanks', true, true));				
					}
				}
			}
			else
			{
				echo "<strong>error</strong>\n";
				print_r(vB_Bitfield_Builder::fetch_errors());
				die();
			}
		}
		
		if (!self::$vbulletin->userinfo['permissions'])
		{
			// For some reason, this is missing
			cache_permissions(self::$vbulletin->userinfo);
		}
		
		foreach ((array)self::$vbulletin->bf_ugp["$bitfieldgroup"] as $permname => $bit)
		{
			// Set the permission
			self::$permissions["$permname"] = ((int)self::$vbulletin->userinfo['permissions']["$bitfieldgroup"] & (int)$bit ? 1 : 0);
		}
	}
	
	/**
	* Quick Method of building the CPNav Template
	*
	* @param	string	The selected item in the CPNav
	*/	
	public static function construct_nav($selectedcell = 'main')
	{
		global $navclass, $vbphrase;
		global $vbulletin, $show, $template_hook;
	
		$cells = array(
			'main',
			'worldmap',
		);
	
		//($hook = vBulletinHook::fetch_hook('usercp_nav_start')) ? eval($hook) : false;
		
		// set the class for each cell/group
		$navclass = array();
		foreach ($cells AS $cellname)
		{
			$navclass["$cellname"] = (intval(self::$vbulletin->versionnumber) == 3 ? 'alt2' : 'inactive');
		}
		$navclass["$selectedcell"] = (intval(self::$vbulletin->versionnumber) == 3 ? 'alt1' : 'active');
		
		//($hook = vBulletinHook::fetch_hook('usercp_nav_complete')) ? eval($hook) : false;
	}
		
	/**
	* Check if we have permissions to perform an action
	*
	* @param	array		User info
	* @param	array		Permissions info
	* @param	string		Permission to check
	*/		
	public static function check_permissions(&$user, $permissions, $permission)
	{
		if ((!$user['usergroupid'] OR !isset($user['membergroupids'])) AND $user['userid'])
		{
			// Ensure we have this
			$user = fetch_userinfo($user['userid']);
		}
		
		if (!is_array($user['permissions']))
		{
			// Ensure we have the perms
			cache_permissions($user);
		}
		
		if ($user['membergroupids'])
		{
			$ugs = explode(',', $user['membergroupids']);
			$ugs[] = $user['usergroupid'];
		}
		else
		{
			$ugs = array($user['usergroupid']);
		}
		
		if (!$ugs[0])
		{
			// Hardcode guests
			$ugs[0] = 1;
		}
		
		//self::$vbulletin->usergroupcache
		foreach ($ugs as $usergroupid)
		{
			if ($permissions["$usergroupid"]["$permission"])
			{
				// Allow
				return true;
			}
		}
		
		// We didn't make it
		return false;
	}
	
	/**
	* Class factory. This is used for instantiating the extended classes.
	*
	* @param	string			The type of the class to be called (user, forum etc.)
	* @param	vB_Registry		An instance of the vB_Registry object.
	* @param	integer			One of the ERRTYPE_x constants
	*
	* @return	vB_DataManager	An instance of the desired class
	*/
	public static function &datamanager_init($classtype, &$registry, $errtype = ERRTYPE_STANDARD)
	{
		if (empty(self::$called))
		{
			// include the abstract base class
			require_once(DIR . '/includes/class_dm.php');
			self::$called = true;
		}
	
		if (preg_match('#^\w+$#', $classtype))
		{
			require_once(DIR . '/dbtech/thanks/includes/class_dm_' . strtolower($classtype) . '.php');
	
			$classname = 'Thanks_DataManager_' . $classtype;
			$object = new $classname($registry, $errtype);
	
			return $object;
		}
	}
	
	/**
	* JS class fetcher for AdminCP
	*
	* @param	string	The JS file name or the code
	* @param	boolean	Whether it's a file or actual JS code
	*/
	public static function js($js = '', $file = true, $echo = true)
	{
		$output = '';
		if ($file)
		{
			$output = '<script type="text/javascript" src="' . self::$vbulletin->options['bburl'] . '/dbtech/thanks/clientscript/thanks' . $js . '.js?v=' . self::$versionnumber . '"></script>';
		}
		else
		{
			$output = "
				<script type=\"text/javascript\">
					<!--
					$js
					// -->
				</script>
			";
		}
		
		if ($echo)
		{
			echo $output;
		}
		else
		{
			return $output;
		}
	}	
		
	/**
	* Entry cache parser for the front-end
	*
	* @param	array	The unprepared entry cache
	*/
	public static function prepare_entry_cache()
	{
		foreach (self::$entrycache as $postid => $entrytypes)
		{
			foreach ($entrytypes as $entrytype => $results)
			{
				// Count how many of each result we have
				$i = 0;
				foreach ($results['data'] as $key => $result)
				{
					// Store a copy of this
					self::$entrycache["$postid"]["$entrytype"]['data_full']["$result[userid]"] = $result;
					
					if (self::$isPro)
					{										
						// Check how many we've done
						$i++;
						
						if ($i > 5)
						{
							// Get rid of content that goes beyond the limit
							unset(self::$entrycache["$postid"]["$entrytype"]['data']["$key"]);
							
							// Increment the "others" counter
							self::$entrycache["$postid"]["$entrytype"]['totals']++;					
						}
					}
				}
			}
		}
		
		foreach (self::$entrycache as $postid => $entrytypes)
		{
			foreach ($entrytypes as $entrytype => $results)
			{
				// Reset the array
				self::$entrycache["$postid"]["$entrytype"]['data'] = array();
				
				foreach ($results['data'] as $key => $result)
				{
					// Fetch musername
					fetch_musername($result);
					
					self::$entrycache["$postid"]["$entrytype"]['data']["$result[userid]"] = '<a href="' . (intval(self::$vbulletin->versionnumber) == 3 ? "member.php?" . self::$vbulletin->session->vars['sessionurl'] . "u=$result[userid]" : fetch_seo_url('member', $result)) . '" target="_blank" title="' . vbdate(self::$vbulletin->options['dateformat'], $result['dateline']) . ' ' . vbdate(self::$vbulletin->options['timeformat'], $result['dateline']) . '">' . trim($result['musername']) . '</a>';
				}
			}
		}	
	}
	
	/**
	* Caches the Thanks permissions for a specified user
	*
	* @param	array	The unprepared entry cache
	*/	
	function cache_permissions(&$user)
	{
		if (is_array($user['permissions']['dbtech_thanks']))
		{
			// We've already cached these permissions
			return true;
		}
		
		// set the usergroupid of the user's primary usergroup
		$USERGROUPID = $user['usergroupid'];
	
		if ($USERGROUPID == 0)
		{ // set a default usergroupid if none is set
			$USERGROUPID = 1;
		}
	
		// initialise $membergroups - make an array of the usergroups to which this user belongs
		$membergroupids = fetch_membergroupids_array($user);
	
		// build usergroup permissions
		if (sizeof($membergroupids) == 1 OR !((int)self::$vbulletin->usergroupcache["$USERGROUPID"]['genericoptions'] & (int)self::$vbulletin->bf_ugp_genericoptions['allowmembergroups']))
		{
			// if primary usergroup doesn't allow member groups then get rid of them!
			$membergroupids = array($USERGROUPID);
			
			foreach (self::$cache['buttons'] as $buttonid => $button)
			{
				// just return the permissions for the user's primary group (user is only a member of a single group)
				$user['permissions']['dbtech_thanks']["$buttonid"] = $button['permissions']["$USERGROUPID"];
			}
		}
		else
		{
			// return the merged array of all user's membergroup permissions (user has additional member groups)
			foreach ($membergroupids AS $usergroupid)
			{
				foreach (self::$cache['buttons'] as $buttonid => $button)
				{
					foreach ($button['permissions']["$usergroupid"] as $varname => $yesno)
					{
						// add to the permissions
						$user['permissions']['dbtech_thanks']["$buttonid"]["$varname"] |= $yesno;
					}
				}
			}
		}
	
		if (!empty($user['infractiongroupids']))
		{
			$infractiongroupids = explode(',', str_replace(' ', '', $user['infractiongroupids']));
		}
		else
		{
			$infractiongroupids = array();
		}
	
		foreach ($infractiongroupids AS $usergroupid)
		{
			foreach (self::$cache['buttons'] as $buttonid => $button)
			{
				foreach ($button['permissions']["$usergroupid"] as $varname => $yesno)
				{
					// infraction group permissions override normal permissions
					$user['permissions']['dbtech_thanks']["$buttonid"]["$varname"] &= $yesno;
				}
			}
		}

		return true;
	}
	
	/**
	* Fetches all valid forum ids
	*
	* @return	array	List of forum ids we can access
	*/	
	public static function fetch_forumids()
	{
		global $vbulletin;
		$forumcache = $vbulletin->forumcache;
		/*
		$excludelist = explode(',', $vbulletin->options['dbtech_infopanels_forum_exclude']);
		foreach ($excludelist AS $key => $excludeid)
		{
			$excludeid = intval($excludeid);
			unset($forumcache["$excludeid"]);
		}
		*/
	
		$forumids = array_keys($forumcache);
		
		// get forum ids for all forums user is allowed to view
		foreach ($forumids AS $key => $forumid)
		{
			if (is_array($includearray) AND empty($includearray["$forumid"]))
			{
				unset($forumids["$key"]);
				continue;
			}
	
			$fperms =& $vbulletin->userinfo['forumpermissions']["$forumid"];
			$forum =& $vbulletin->forumcache["$forumid"];
	
			if (!((int)$fperms & (int)$vbulletin->bf_ugp_forumpermissions['canview']) OR !((int)$fperms & (int)$vbulletin->bf_ugp_forumpermissions['canviewthreads']) OR !verify_forum_password($forumid, $forum['password'], false))
			{
				unset($forumids["$key"]);
			}
		}
		
		// Those shouts with 0 as their forumid
		$forumids[] = 0;
		
		return $forumids;
	}
	
	/**
	* Parses the [HIDE] BBCode
	*
	* @param	string	Original message
	* @param	string	Overriding
	*/	
	public static function parse_bbcode(&$message, $override)
	{
		if (!self::$isPro)
		{
			// We may or may not require something
			$message = $override;
		}
		else
		{
			// We may or may not require something
			$message = preg_replace('/\[hide\](.*)\[\/hide\]/isU', $override, $message);
		}
	}
	
}


// #############################################################################
// filter functionality class

/**
* Class that handles filtering arrays
*
* @package	Framework
* @version	$ $Rev$ $
* @date		$ $Date$ $
*/
class THANKS_FILTER
{
	/**
	* Id Field we are using
	*
	* @private	string
	*/	
	private static $idfield 	= NULL;
	
	/**
	* Id value we are looking for
	*
	* @private	mixed
	*/	
	private static $idval 		= NULL;
	
	/**
	* Sets up and begins the filtering process 
	*
	* @param	array	Array to filter
	* @param	string	What the ID Field is
	* @param	mixed	What we are looking for
	*
	* @return	array	Filtered array
	*/
	public static function filter($array, $idfield, $idval)
	{
		// Set the two things we can't pass on to the callback
		self::$idfield 	= $idfield;
		self::$idval	= $idval;
		
		// Filter this shiet
		return array_filter($array, array(__CLASS__, 'do_filter'));
	}
	
	/**
	* Checks if this element should be included
	*
	* @param	array	Array to filter
	*
	* @return	boolean	Whether we should include this or not
	*/	
	protected static function do_filter($array)
	{
		$idfield 	= self::$idfield;
		$idval		= self::$idval;
		return ($array["$idfield"] == $idval);
	}
}

// #############################################################################
// JSON wrapper

if (!function_exists('json_encode'))
{
	// Grab the JSON class
	require_once(DIR . '/dbtech/thanks/includes/class_json.php');
	
	// #########################################################################
	// json_encode wrapper
	function json_encode($arg)
	{
		global $services_json;
		
		if (!isset($services_json))
		{
			// Ensure this is set
			$services_json = new Services_JSON();
		}
		
		return $services_json->encode($arg);
	}
	
	// #########################################################################
	// json_decode wrapper
	function json_decode($arg)
	{
		global $services_json;
		
		if (!isset($services_json))
		{
			// Ensure this is set
			$services_json = new Services_JSON();
		}
		
		return $services_json->decode($arg);
	}
} 


/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Dragonbyte Technologies Advanced Post Thanks & Like Pro 1.1.9    # ||
|| # ---------------------------------------------------------------- # ||
|| # Nulled by x iJB x                                                # ||
|| # This is a p0wersurge.com release                                 # ||
|| # ---------------------------- Greetz ---------------------------- # ||
|| # TeamPS extends their greetz to all the nullification scene,      # ||
|| # including FS and DGT. Thanks go to FS for teaching me to null    # ||
|| # properly. Thanks also go to decodeby.us (RIP) for the ionCube    # ||
|| # decoder I use for decoding certain scripts :p                    # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/